namespace FishFactsClasses {
	using System;
	using System.ComponentModel;
	using System.Collections;
	using Borland.Eco.Services;
	using Borland.Eco.ObjectRepresentation;
	using Borland.Eco.ObjectImplementation;
	using Borland.Eco.UmlRt;
	using Borland.Eco.UmlCodeAttributes;

	[UmlCollection(typeof(BioLife))]
	public interface IBioLifeList : ICollection
	{
		#region ECO generated code
		BioLife this[int index]
		{
			get;
			set;
		}
		int Add(BioLife value);
		bool Contains(BioLife value);
		int IndexOf(BioLife value);
		void Insert(int index, BioLife value);
		void Remove(BioLife value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
	[UmlElement("Package", Id="a4d2f33f-3ac3-4cc8-9eae-e3a916132c94")]
	[EcoCodeGenVersion("2.0")]
	[UmlMetaAttribute("ownedElement", typeof(BioLife))]
	public class FishFactsPackage {
	}
	[UmlElement(Id="04725214-dd48-4513-a969-d71226d7346c")]
	public class BioLife : ILoopBack {
		
		public class BioLifeListAdapter : ObjectListAdapter, IBioLifeList
		{
			public BioLifeListAdapter(IList source) : 
					base(source)
			{
			}
			public BioLife this[int index]
			{
				get
				{
					return ((BioLife)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(BioLife value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(BioLife value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(BioLife value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, BioLife value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(BioLife value)
			{
				this.Adaptee.Remove(value);
			}
		}

		#region AutoGenerated ECO code

		public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

		public BioLife(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 8);
			public const int LengthInCentimeters = Eco_FirstMember;
			public const int SpeciesNo = (LengthInCentimeters + 1);
			public const int CommonName = (SpeciesNo + 1);
			public const int Notes = (CommonName + 1);
			public const int SpeciesName = (Notes + 1);
			public const int Category = (SpeciesName + 1);
			public const int Graphic = (Category + 1);
			public const int LengthInInches = (Graphic + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

		public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

		public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

		protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

		protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

		#endregion Autogenerated ECO code

		public BioLife(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
				// User code here
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}

		[UmlElement(Id="53e2376c-8da4-4f19-80f3-0be359091823", Index=Eco_LoopbackIndices.SpeciesNo)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public double SpeciesNo
		{
			get
			{
				return ((double)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.SpeciesNo)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.SpeciesNo, ((object)(value)));
			}
		}
		[UmlElement(Id="cf85fae1-73cf-4a4b-944b-d1bfc4e1fd35", Index=Eco_LoopbackIndices.Category)]
		public string Category
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Category)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Category, ((object)(value)));
			}
		}
		[UmlElement(Id="9d227ef7-1590-438b-8869-9d50940be79b", Index=Eco_LoopbackIndices.CommonName)]
		public string CommonName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.CommonName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.CommonName, ((object)(value)));
			}
		}
		[UmlElement(Id="b1f36498-5709-42fe-b530-ad764ad5d9e2", Index=Eco_LoopbackIndices.SpeciesName)]
		public string SpeciesName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.SpeciesName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.SpeciesName, ((object)(value)));
			}
		}
		[UmlElement(Id="270932ff-8306-4e6f-a92c-16c8ab3b3bff", Index=Eco_LoopbackIndices.LengthInCentimeters)]
		public double LengthInCentimeters
		{
			get
			{
				return ((double)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.LengthInCentimeters)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.LengthInCentimeters, ((object)(value)));
			}
		}
		[UmlElement(Id="fae1141e-cb47-49a9-95b4-46aa614d5bfa", Index=Eco_LoopbackIndices.LengthInInches)]
		public double LengthInInches
		{
			get
			{
				return ((double)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.LengthInInches)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.LengthInInches, ((object)(value)));
			}
		}
		[UmlElement(Id="af5d861e-e40d-4999-a0d6-f3cbe8d7c381", Index=Eco_LoopbackIndices.Notes)]
		public string Notes
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Notes)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Notes, ((object)(value)));
			}
		}
		[UmlElement(Id="e4cfef21-a2a8-45fa-b023-c134fbb5737a", Index=Eco_LoopbackIndices.Graphic)]
		[UmlTaggedValue("Eco.DelayedFetch", "True")]
		public byte[] Graphic
		{
			get
			{
				return ((byte[])(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Graphic)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Graphic, ((object)(value)));
			}
		}
	}
}
